/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_extensions.h"
#include "test_common.h"

mx_endpoint_addr_t addr;
uint64_t my_nic_id;
uint32_t my_eid;

int send_completed_count;
int recv_completed_count;
int processed_in_handler_count;
int send_posted_count;

mx_unexp_handler_action_t
unexp_handler(void *context,
	      mx_endpoint_addr_t source,
	      uint64_t match_value,
	      uint32_t length,
	      void * data_if_available)
{
  mx_unexp_handler_action_t result;
  mx_endpoint_t ep = context;
  static int message = 0;
  uint32_t incoming_eid;
  uint64_t incoming_nic_id;
  mx_return_t ret;

  printf("    CB: got unexp with length %d and data %p\n", length, data_if_available);

  ret = mx_decompose_endpoint_addr(source, &incoming_nic_id, &incoming_eid);
  insist(ret == MX_SUCCESS);
  insist(incoming_nic_id == my_nic_id);
  insist(incoming_eid == my_eid);

  /* alternate between processing (if possible) and post a receive */
  if (!((++message)%2) && data_if_available) {
    printf("    CB: processing message #%d with available data (\"%s\")\n", message, (char *) data_if_available);
    result = MX_RECV_FINISHED;
    processed_in_handler_count++;
    mx_wakeup(ep);
  } else {
    mx_return_t ret;
    mx_request_t req;
    if (data_if_available)
      printf("    CB: posting receive #%d even if data is available (\"%s\")\n", message, (char *) data_if_available);
    else
      printf("    CB: posting receive #%d since data not available\n", message);
    ret = mx_irecv(ep, NULL, 0, 0, 0, (void *)(uintptr_t)(10+message), &req);
    insist(ret == MX_SUCCESS);
    result = MX_RECV_CONTINUE;
  }

  return result;
}

void * send_func(void *arg)
{
  mx_return_t ret;
  mx_request_t req;
  mx_endpoint_t ep = arg;
  char * message1 = "my message #1";
  mx_segment_t seg1 = {message1, 14};
  char * message2 = "my message #2 is long and does not fit in tiny receives";
  mx_segment_t seg2 = {message2, 56};
  char * message3 = "my message #3 is very very very very very very very very very very very very very very very very very very very very very very very very long and does not fit in small receives";
  mx_segment_t seg3 = {message3, 177};
  char * message4 = "my message #4 is short too";
  mx_segment_t seg4 = {message4, 27};
  char * message5 = "my message #5 is very very long and does not fit in tiny receives";
  mx_segment_t seg5 = {message5, 64};
  char * message6 = "my message #6 is very very very very very very very very very very very very very very very very very very very very very very long and does not fit in small receives";
  mx_segment_t seg6 = {message6, 169};

  printf("  TH: sending message #1\n");
  ret = mx_isend(ep, &seg1, 1, addr, 0, (void*) 1, &req);
  insist(ret == MX_SUCCESS);

  printf("  TH: sending message #2\n");
  ret = mx_isend(ep, &seg2, 1, addr, 0, (void*) 2, &req);
  insist(ret == MX_SUCCESS);

  printf("  TH: sending message #3\n");
  ret = mx_isend(ep, &seg3, 1, addr, 0, (void*) 3, &req);
  insist(ret == MX_SUCCESS);

  printf("  TH: sending message #4\n");
  ret = mx_isend(ep, &seg4, 1, addr, 0, (void*) 4, &req);
  insist(ret == MX_SUCCESS);

  printf("  TH: sending message #5\n");
  ret = mx_isend(ep, &seg5, 1, addr, 0, (void*) 5, &req);
  insist(ret == MX_SUCCESS);

  printf("  TH: sending message #6\n");
  ret = mx_isend(ep, &seg6, 1, addr, 0, (void*) 6, &req);
  insist(ret == MX_SUCCESS);

  pthread_exit(NULL);
  return NULL;
}

int
main(void)
{
  mx_endpoint_t ep;
  mx_return_t ret;
  pthread_t send_th;

  ret = mx_init();
  insist(ret == MX_SUCCESS);

  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);

  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  ret = mx_decompose_endpoint_addr(addr, &my_nic_id, &my_eid);
  insist(ret == MX_SUCCESS);

  /* we're going to truncate */
  (void) mx_set_error_handler(MX_ERRORS_RETURN);

  ret = mx_register_unexp_handler(ep, unexp_handler, ep);
  insist(ret == MX_SUCCESS);

  recv_completed_count = 0;
  processed_in_handler_count = 0;
  send_completed_count = 0;
  send_posted_count = 6;

  pthread_create(&send_th, NULL, &send_func, ep);

  while (send_posted_count != recv_completed_count + processed_in_handler_count
	 || send_completed_count != send_posted_count) {
    mx_status_t status;
    uint32_t result;

    ret = mx_wait_any(ep, MX_INFINITE, 0, 0, &status, &result);
    insist(ret == MX_SUCCESS);
    if (!result)
      continue;

    if ((int)(uintptr_t)status.context >= 1 && (int)(uintptr_t)status.context <= 9) {
      printf("send #%d completed\n", (int)(uintptr_t)status.context);
      send_completed_count++;
    } else {
      printf("receive #%d completed\n", (int)(uintptr_t)status.context - 10);
      recv_completed_count++;
    }
  }

  pthread_join(send_th, NULL);

  ret = mx_close_endpoint(ep);
  insist(ret == MX_SUCCESS);

  ret = mx_finalize();
  insist(ret == MX_SUCCESS);

  return 0;
}
